%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% post processor - arrange Darcy-2D in matrices
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clc
clear all 
close all;	% close all the open figure windows

%%%%%%%%%%% read meshinp.txt %%%%%%%%%%%%
fid = fopen('meshinp.txt','r');

line = fgets(fid);	% read line (Darcy)
line = fgets(fid);	% read line (Xmin, Xmax, Ymin, Ymax)
line = fgets(fid);	% read line (Nx, Ny)
v = sscanf(line, '%i');
Nx = v(1);
Ny = v(2);

%%%%%%%%%%% read finp.txt %%%%%%%%%%%%
% fid = fopen('finp.txt','r');

% line = fgets(fid);	% read line (Ne, Nn, Nb, Nm)
% line = fgets(fid);	% read line (Nd, Ng)
% line = fgets(fid);	% read line (Sx)

%%%%%%%%%% read post.msh %%%%%%%%%%%
fid = fopen('post.msh','r');
for m =1:6
  line = fgets(fid);	% read 6 lines
end	% m

% read nodal coordinates
for j = 1:Ny+1
  for i = 1:Nx+1
    line = fgets(fid);	% read line (n, x, y, IC)
%    v = sscanf(line, '%i %e %e %e %e');
  end	% i
end	% j

for m =1:5
  line = fgets(fid);	% read 5 lines
end	% m

% read elements
for j = 1:Ny
  for i = 1:Nx
    line = fgets(fid);	% read line (elm-number elm-type number-of-tags < tag > ... node-number-list)
  end	% i
end	% j

for m =1:12
  line = fgets(fid);	% read 12 lines
end	% m


% read elements data (D)
for j = 1:Ny
  for i = 1:Nx
    line = fgets(fid);	% read line (elm-number number-of-nodes-per-element value ... Dxx, Dxy,.. Dzz)
  end	% i
end	% j

for m =1:12
  line = fgets(fid);	% read 12 lines
end	% m

% read nodal data (h)
    for j = 1:Ny+1
      for i = 1:Nx+1
        line = fgets(fid);	% read line (node-number value ...)
        v = sscanf(line, '%i %e');
        h(j,i) = v(2);
      end	% i
    end		% j

    for m =1:12
      line = fgets(fid);	% read 12 lines
    end		% m

% read nodal data (T)
    for j = 1:Ny+1
      for i = 1:Nx+1
        line = fgets(fid);	% read line (node-number value ...)
        v = sscanf(line, '%i %e');
        T(j,i) = v(2);
      end	% i
    end		% j

    for m =1:12
      line = fgets(fid);	% read 12 lines
    end		% m

% read elements data (q)
for j = 1:Ny
  for i = 1:Nx
    line = fgets(fid);	% read line (elm-number number-of-nodes-per-element value ... Dxx, Dxy,.. Dzz)
    v = sscanf(line, '%i %e %e %e');
    qx(j,i)= v(2);
    qy(j,i)= v(3);
  end	% i
end	% j

for m =1:12
  line = fgets(fid);	% read 12 lines
end	% m

fclose('all');  % close all files
